import time,sys,thread

from VisualSphere import *
from VisualLattice import *


class Visuals:
    def __init__(self, nSpinsX, nSpinsY, k):
        self.nSpinsX = nSpinsX
        self.nSpinsY = nSpinsY
        self.k = k
      
        self.tracerLength = 64

        self.vSphere = VisualSphere(self.nSpinsX, self.nSpinsY, self.tracerLength)
        self.vLattice = VisualLattice(self.nSpinsX, self.nSpinsY, self.tracerLength, self.k)


    def visualLoop(self, nLattice):

        self.vSphere.updateTracers(nLattice)
        self.vSphere.updateVectors(nLattice)
        self.vSphere.updatePoints(nLattice)

        self.vLattice.updateVectors(nLattice)
        self.vLattice.updatePoints(nLattice)
        self.vLattice.updateTracers(nLattice)
        self.vLattice.updateTorqueVectors(nLattice)     # every piece of data has a trajectory
        self.vLattice.updateBonds(nLattice)


    def reset(self):
        self.vSphere.resetTracers()
        self.vLattice.resetTracers()








